dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 8, 210, 290, "assets/images/table/island_8", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 8, 220, 440, "assets/images/table/island_8", "assets/images/food/item_mark4", "B" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 1;
numServers = 1;
maxCoupleHappiness = 400;


-- Group 1

guest = LManager.GenGuest(male03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male02;
guest.likes={male03};
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 3, 3000);


guest = LManager.GenGuest(male03);
guest.matchType = male02;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(4, 6, 40000);


-- Group 2

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 10, 56000);

-- Group 3

guest = LManager.GenGuest(male02);
guest.matchType = male03;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table2;
guest.likes = {female01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 14, 80000);


-- Group 4

guest = LManager.GenGuest(male03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = male03;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 17, 110000);

-- Group 5

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 19, 150000);


-- Group 6

guest = LManager.GenGuest(male02);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male02;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(20, 22, 180000);

-- Group 7

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(23, 24, 200000);

LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("dogDelay", 75000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("cakeTipDelay", 110000); 
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("speakerDelay", 140000); 
LManager:SetLevelSetting ("speakerChance", 100);

LManager:AddReseatingRequestForGuest( 20000, female01 );
LManager:AddReseatingRequestForGuest( 50000, male02 );
LManager:AddReseatingRequestForGuest( 80000, male03 );
LManager:AddReseatingRequestForGuest( 100000, male02 );
LManager:AddReseatingRequestForGuest( 130000, female01 );
LManager:AddReseatingRequestForGuest( 150000, male02 );
LManager:AddReseatingRequestForGuest( 180000, male03 );
LManager:AddReseatingRequestForGuest( 210000, female01 );
LManager:AddReseatingRequestForGuest( 240000, male02 );
LManager:AddReseatingRequestForGuest( 270000, male03 );


-- Set up the Level Settings
LManager:SetLevelNumber(4,5);
LManager:SetLevelScores(10000, 13500);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Disco Dance 1.ogg","assets/audio/music/uptempo_3.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );

TutorialSteps =
{
	start =
	{
		action = function()
		end,
		triggers = 
		{
			[1] = { condition = "REQUEST_DESIRE", parameter = "WANT_RESIT", next = "WaitForRequestToBeMet" },
		},
	},
	
	WaitForRequestToBeMet = 
	{
		action = function()
			TextBox(470, 260, "tutorialStep25", 15000);
		end,
		triggers = 
		{
			[1] = { condition = "IS_RESEATED_CORRECTLY", parameter = "", next = "Done" },
			[2] = { condition = "IS_RESEATED_INCORRECTLY", parameter = "", next = "SecondChance" },
		},
	},
	
	SecondChance = 
	{
		action = function()
			HideTextBox();
		end,
		triggers = 
		{
			[1] = { condition = "REQUEST_DESIRE", parameter = "WANT_RESIT", next = "WaitForRequestToBeMet" },
		},
	},
	
	SecondChanceDisplay = 
	{
		action = function()
			TextBox(470, 260, "tutorialStep25", 10000);
		end,
		triggers = 
		{
			[1] = { condition = "IS_RESEATED_CORRECTLY", parameter = "", next = "Done" },
			[2] = { condition = "IS_RESEATED_INCORRECTLY", parameter = "", next = "Done" },
		},
	},
		
	Done = 
	{
		action = function()
			HideTextBox();
			HideArrows();
		end,
		triggers =
		{
		}
	}
}
